/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JavaCompiler
extends Compiler {
    private final Log log = LogFactory.getLog(JavaCompiler.class);

    @Override
    protected void generateClass(Map<String, SmapStratum> map) throws JasperException, IOException {
        JavacErrorDetail[] javacErrorDetailArray;
        long l = 0L;
        if (this.log.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        javax.tools.JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticCollector, null, Charset.forName(this.ctxt.getOptions().getJavaEncoding()));
        Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(List.of(new File(this.ctxt.getServletJavaFileName())));
        List<String> list = List.of("-classpath", this.ctxt.getClassPath(), "-source", this.ctxt.getOptions().getCompilerSourceVM(), "-target", this.ctxt.getOptions().getCompilerTargetVM());
        Boolean bl = javaCompiler.getTask(null, standardJavaFileManager, diagnosticCollector, list, null, iterable).call();
        ArrayList<JavacErrorDetail> arrayList = new ArrayList<JavacErrorDetail>();
        if (!bl.booleanValue()) {
            javacErrorDetailArray = diagnosticCollector.getDiagnostics().iterator();
            while (javacErrorDetailArray.hasNext()) {
                Diagnostic diagnostic = javacErrorDetailArray.next();
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                try {
                    arrayList.add(ErrorDispatcher.createJavacError(((JavaFileObject)diagnostic.getSource()).getName(), this.pageNodes, new StringBuilder(diagnostic.getMessage(Locale.getDefault())), (int)diagnostic.getLineNumber(), this.ctxt));
                }
                catch (JasperException jasperException) {
                    this.log.error((Object)Localizer.getMessage("jsp.error.compilation.jdtProblemError"), (Throwable)((Object)jasperException));
                }
            }
        }
        if (!this.ctxt.keepGenerated() && !(javacErrorDetailArray = new File(this.ctxt.getServletJavaFileName())).delete()) {
            throw new JasperException(Localizer.getMessage("jsp.warning.compiler.javafile.delete.fail", new Object[]{javacErrorDetailArray}));
        }
        if (!arrayList.isEmpty()) {
            javacErrorDetailArray = arrayList.toArray(new JavacErrorDetail[0]);
            this.errDispatcher.javacError(javacErrorDetailArray);
        }
        if (this.log.isDebugEnabled()) {
            long l2 = System.currentTimeMillis();
            this.log.debug((Object)Localizer.getMessage("jsp.compiled", this.ctxt.getServletJavaFileName(), l2 - l));
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(map);
        }
    }
}

